let categories = JSON.parse(`[
    {
        "id": 1,
        "name": "Vocabulary",
        "img": "vocab.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 2,
        "name": "Sports",
        "img": "sports.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 3,
        "name": "Festivals",
        "img": "festival-min.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 4,
        "name": "Fun Maths",
        "img": "math.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 5,
        "name": "English Grammar",
        "img": "grammar.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 6,
        "name": "Monuments",
        "img": "monument.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 7,
        "name": "Food Brands",
        "img": "brand.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 8,
        "name": "Knowledge",
        "img": "testknow.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 9,
        "name": "Entertainment",
        "img": "entertainment.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 10,
        "name": "General Trivia",
        "img": "trivia-min.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 11,
        "name": "Automobiles",
        "img": "auto.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 12,
        "name": "Bollywood",
        "img": "bollywood.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 13,
        "name": "Birds And Animals",
        "img": "animal.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 14,
        "name": "Personalities",
        "img": "famous.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 15,
        "name": "Food & Beverages",
        "img": "food.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 16,
        "name": "Business",
        "img": "business-min.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 17,
        "name": "Litrature",
        "img": "literature-min.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    },
    {
        "id": 18,
        "name": "Fun Science",
        "img": "science.png",
        "created_at": "2023-12-28T09:00:04.000Z"
    }
]`);

let sub_category = JSON.parse(`[
    {
        "sc_id": 24,
        "sc_name": "English-Hindi-Translation",
        "c_name": "Vocabulary",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "grammar.png",
        "id": 1,
        "c_img": "vocab.png"
    },
    {
        "sc_id": 7,
        "sc_name": "Cricket",
        "c_name": "Sports",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "sports.png",
        "id": 2,
        "c_img": "sports.png"
    },
    {
        "sc_id": 13,
        "sc_name": "T-20",
        "c_name": "Sports",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "sports.png",
        "id": 2,
        "c_img": "sports.png"
    },
    {
        "sc_id": 29,
        "sc_name": "Football",
        "c_name": "Sports",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "sports.png",
        "id": 2,
        "c_img": "sports.png"
    },
    {
        "sc_id": 31,
        "sc_name": "FIFA",
        "c_name": "Sports",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "sports.png",
        "id": 2,
        "c_img": "sports.png"
    },
    {
        "sc_id": 11,
        "sc_name": "Raksha-Bandhan",
        "c_name": "Festivals",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "festival-min.png",
        "id": 3,
        "c_img": "festival-min.png"
    },
    {
        "sc_id": 12,
        "sc_name": "Onam",
        "c_name": "Festivals",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "festival-min.png",
        "id": 3,
        "c_img": "festival-min.png"
    },
    {
        "sc_id": 21,
        "sc_name": "Algebra",
        "c_name": "Fun Maths",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "math.png",
        "id": 4,
        "c_img": "math.png"
    },
    {
        "sc_id": 22,
        "sc_name": "Trignometry",
        "c_name": "Fun Maths",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "math.png",
        "id": 4,
        "c_img": "math.png"
    },
    {
        "sc_id": 23,
        "sc_name": "Play-with-Shapes",
        "c_name": "Fun Maths",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "math.png",
        "id": 4,
        "c_img": "math.png"
    },
    {
        "sc_id": 25,
        "sc_name": "Easy-Math-Trivia",
        "c_name": "Fun Maths",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "math.png",
        "id": 4,
        "c_img": "math.png"
    },
    {
        "sc_id": 1,
        "sc_name": "Noun-Pronoun",
        "c_name": "English Grammar",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "grammar.png",
        "id": 5,
        "c_img": "grammar.png"
    },
    {
        "sc_id": 32,
        "sc_name": "Verb-Adverb",
        "c_name": "English Grammar",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "grammar.png",
        "id": 5,
        "c_img": "grammar.png"
    },
    {
        "sc_id": 2,
        "sc_name": "National",
        "c_name": "Monuments",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "monument.png",
        "id": 6,
        "c_img": "monument.png"
    },
    {
        "sc_id": 35,
        "sc_name": "Guess-that-brand",
        "c_name": "Food Brands",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "brand.png",
        "id": 7,
        "c_img": "brand.png"
    },
    {
        "sc_id": 17,
        "sc_name": "Easy-Trivia",
        "c_name": "Knowledge",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "testknow.png",
        "id": 8,
        "c_img": "testknow.png"
    },
    {
        "sc_id": 30,
        "sc_name": "GK",
        "c_name": "Knowledge",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "testknow.png",
        "id": 8,
        "c_img": "testknow.png"
    },
    {
        "sc_id": 39,
        "sc_name": "Current-Affairs",
        "c_name": "Knowledge",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "testknow.png",
        "id": 8,
        "c_img": "testknow.png"
    },
    {
        "sc_id": 6,
        "sc_name": "Friends",
        "c_name": "Entertainment",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "entertainment.png",
        "id": 9,
        "c_img": "entertainment.png"
    },
    {
        "sc_id": 8,
        "sc_name": "Movie-Quotes",
        "c_name": "Entertainment",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "entertainment.png",
        "id": 9,
        "c_img": "entertainment.png"
    },
    {
        "sc_id": 18,
        "sc_name": "Guess-The-Movie",
        "c_name": "Entertainment",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "entertainment.png",
        "id": 9,
        "c_img": "entertainment.png"
    },
    {
        "sc_id": 36,
        "sc_name": "Hollywood",
        "c_name": "Entertainment",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "entertainment.png",
        "id": 9,
        "c_img": "entertainment.png"
    },
    {
        "sc_id": 37,
        "sc_name": "Money-Hiest",
        "c_name": "Entertainment",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "entertainment.png",
        "id": 9,
        "c_img": "entertainment.png"
    },
    {
        "sc_id": 38,
        "sc_name": "Mother-of-Dragons",
        "c_name": "Entertainment",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "entertainment.png",
        "id": 9,
        "c_img": "entertainment.png"
    },
    {
        "sc_id": 40,
        "sc_name": "Games",
        "c_name": "Entertainment",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "entertainment.png",
        "id": 9,
        "c_img": "entertainment.png"
    },
    {
        "sc_id": 19,
        "sc_name": "KBC",
        "c_name": "General Trivia",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "trivia-min.png",
        "id": 10,
        "c_img": "trivia-min.png"
    },
    {
        "sc_id": 26,
        "sc_name": "Ultimate-Car-Trivia",
        "c_name": "Automobiles",
        "entryFee": 50,
        "totalPrice": 1000,
        "img": "auto.png",
        "id": 11,
        "c_img": "auto.png"
    },
    {
        "sc_id": 34,
        "sc_name": "Bollywood-Trivia",
        "c_name": "Bollywood",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "bollywood.png",
        "id": 12,
        "c_img": "bollywood.png"
    },
    {
        "sc_id": 14,
        "sc_name": "Find-That-Creature",
        "c_name": "Birds And Animals",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "animal.png",
        "id": 13,
        "c_img": "animal.png"
    },
    {
        "sc_id": 27,
        "sc_name": "Creepy-Crawlies",
        "c_name": "Birds And Animals",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "animal.png",
        "id": 13,
        "c_img": "animal.png"
    },
    {
        "sc_id": 3,
        "sc_name": "Wonder-Women",
        "c_name": "Personalities",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "famous.png",
        "id": 14,
        "c_img": "famous.png"
    },
    {
        "sc_id": 20,
        "sc_name": "History-Makers",
        "c_name": "Personalities",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "famous.png",
        "id": 14,
        "c_img": "famous.png"
    },
    {
        "sc_id": 28,
        "sc_name": "Bollywood-Singers",
        "c_name": "Personalities",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "famous.png",
        "id": 14,
        "c_img": "famous.png"
    },
    {
        "sc_id": 33,
        "sc_name": "Sports",
        "c_name": "Personalities",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "famous.png",
        "id": 14,
        "c_img": "famous.png"
    },
    {
        "sc_id": 15,
        "sc_name": "Food-Trivia",
        "c_name": "Food & Beverages",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "food.png",
        "id": 15,
        "c_img": "food.png"
    },
    {
        "sc_id": 16,
        "sc_name": "Indian-Cuisine",
        "c_name": "Food & Beverages",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "food.png",
        "id": 15,
        "c_img": "food.png"
    },
    {
        "sc_id": 9,
        "sc_name": "Banking-and-Finance",
        "c_name": "Business",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "business-min.png",
        "id": 16,
        "c_img": "business-min.png"
    },
    {
        "sc_id": 10,
        "sc_name": "Fiction",
        "c_name": "Litrature",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "literature-min.png",
        "id": 17,
        "c_img": "literature-min.png"
    },
    {
        "sc_id": 4,
        "sc_name": "Space-Exploration",
        "c_name": "Fun Science",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "science.png",
        "id": 18,
        "c_img": "science.png"
    },
    {
        "sc_id": 5,
        "sc_name": "Everyday-Science",
        "c_name": "Fun Science",
        "entryFee": 50,
        "totalPrice": 10000,
        "img": "science.png",
        "id": 18,
        "c_img": "science.png"
    }
]`);

const container = document.getElementById("categories");

categories.forEach((item) => {
  const div = document.createElement("div");
  div.className = "col h-auto w-full";

  div.innerHTML = `
         <div class="cursor-pointer" onclick="SelectCatSbucat(${item.id})">
            <div class="quiz_cat_tile rounded-2xl p-3 flex items-center justify-center">
                <div class="">
                    <img src="/images/${item.img}" alt=""
                        class="w-16 m-auto rounded-xl  p-1">
                    <p class="font-bold text-sm  mt-2">Festivals</p>
                </div>
            </div>
        </div>
    `;

  container.appendChild(div);
});

const Subcatcontainer = document.getElementById("sub_categories")

function SelectCatSbucat(id){
    Subcatcontainer.innerHTML = ""
    container.innerHTML = ""

    sub_category.forEach((item) => {
        const div = document.createElement("div");
        div.className = "col my-3 h-auto w-full";
      
        div.innerHTML = `
          <div class="q_tile h-auto">
           <a href="/quizentry.html?sc_id=${item.sc_id}">
              <div class="flex p-3 h-full">
                <div class="flex-none w-16 h-16 my-auto">
                  <img src="/images/${item.img}" style="filter: drop-shadow(5px 4px 3px black);" class="w-full object-cover md:h-full" alt="question_img">
                </div>
                <div class="grow w-full h-auto my-auto p-2">
                  <div class="">
                    <p class="font-bold text-xs">${item.c_name} | ${item.sc_name}</p>
                    <p class="font-bold mt-0 text-gray-400 text-sm xs:text-xs">
                      Play &amp; Win ${item.totalPrice} 
                      <i class="fa-solid fa-coins" style="color: #FFD43B;"></i> Coins
                    </p>
                    <p class="entry_fee text-xs m-auto mt-2 w-60">
                      Entry Fee ${item.entryFee} 
                      <i class="fa-solid fa-coins" style="color: #FFD43B;"></i>
                    </p>
                  </div>
                </div>
                <div class="flex-none w-14 h-14 my-auto">
                  <div class="quiz_play_fwd_btn p-2">
                    <i class="fa-solid fa-chevron-right font-extrabold"></i>
                  </div>
                </div>
              </div>
             </a>
          </div>
        `;
      
        Subcatcontainer.appendChild(div);
      });
}